#include "ShowImagerForm.h"

using namespace irImagerShow;
using namespace System;
using namespace System::Windows::Forms;


[STAThread]
void Main(array<String^>^ args)
{
  if (args->Length < 1)
  {
    Windows::Forms::MessageBox::Show("Please pass xml configuration file as first argument", "Missing argument", Windows::Forms::MessageBoxButtons::OK, Windows::Forms::MessageBoxIcon::Error);
    return;
  }

	Application::EnableVisualStyles();
	Application::SetCompatibleTextRenderingDefault(false);

	ShowImagerForm showImagerForm(args[0]);
	Application::Run(%showImagerForm);
}

unsigned char clip(int val) { return (val <= 255) ? ((val > 0) ? val : 0) : 255; };

System::Void ShowImagerForm::button_start_Click(System::Object^  sender, System::EventArgs^  e)
{
	
	if (this->thermalDevice) delete this->thermalDevice;

	this->thermalDevice = new ThermalDevice(_xmlconfig);

	if (!this->thermalDevice->isReadyToStart())
	{
		Windows::Forms::MessageBox::Show("Start failed!", "Missing", Windows::Forms::MessageBoxButtons::OK, Windows::Forms::MessageBoxIcon::Error);
		return;
	}

	this->imgWidth = this->thermalDevice->getWidth();
	this->imgHeight = this->thermalDevice->getHeight();
	this->imgSize = this->imgWidth * this->imgHeight;

	bmp = gcnew Bitmap(this->imgWidth, this->imgHeight, System::Drawing::Imaging::PixelFormat::Format24bppRgb);
	System::Drawing::Rectangle rect = System::Drawing::Rectangle(0, 0, bmp->Width, bmp->Height);
	Imaging::BitmapData^ bmpData = bmp->LockBits(rect, Imaging::ImageLockMode::ReadWrite, bmp->PixelFormat);
	rgbValues = gcnew array<Byte>(bmpData->Stride * this->imgHeight);
	bmp->UnlockBits(bmpData);

	this->pictureBox1->Size = Drawing::Size(this->imgWidth, this->imgHeight);
	this->painted = true;
	
	this->frameGrabTimer = gcnew MyTimer();
	this->frameGrabTimer->passingRef = (System::Object ^)this;
	this->frameGrabTimer->Interval = 1000.0f / this->thermalDevice->getDeviceFrequency();
	this->frameGrabTimer->Elapsed += gcnew System::Timers::ElapsedEventHandler(this, &irImagerShow::ShowImagerForm::OnElapsed);

	this->frameGrabTimer->Start();

	this->button_start->Enabled = !this->thermalDevice->start();
}

System::Void ShowImagerForm::button_stop_Click(System::Object^  sender, System::EventArgs^  e)
{
	if (this->frameGrabTimer != nullptr)
	{
		this->frameGrabTimer->Stop();
		this->frameGrabTimer->Elapsed -= gcnew System::Timers::ElapsedEventHandler(this, &irImagerShow::ShowImagerForm::OnElapsed);
	}
	if(this->thermalDevice) this->thermalDevice->stop();

	this->button_start->Enabled = true;
}

void ShowImagerForm::GetBitmap(Bitmap^ Bmp, unsigned short *values)
{
	int stride_diff;
	// Lock the bitmap's bits.  
	System::Drawing::Rectangle rect = System::Drawing::Rectangle(0, 0, Bmp->Width, Bmp->Height);
	Imaging::BitmapData^ bmpData = Bmp->LockBits(rect, Imaging::ImageLockMode::ReadWrite, Bmp->PixelFormat);
	stride_diff = bmpData->Stride - this->imgWidth * 3;

	// Get the address of the first line.
	IntPtr ptr = bmpData->Scan0;

	short mn, mx;
	GetBitmap_Limits(values, &mn, &mx);
	double Fact = 255.0 / (mx - mn);

	for (unsigned int dst = 0, src = 0, y = 0; y < this->imgHeight; y++, dst += stride_diff)
		for (unsigned int x = 0; x < this->imgWidth; x++, src++, dst += 3)
			rgbValues[dst] = rgbValues[dst + 1] = rgbValues[dst + 2] = min(max((int)(Fact * (values[src] - mn)), 0), 255);


	// Copy the RGB values back to the bitmap
	System::Runtime::InteropServices::Marshal::Copy(rgbValues, 0, ptr, rgbValues->Length);

	// Unlock the bits.
	Bmp->UnlockBits(bmpData);
}

void ShowImagerForm::GetBitmap_Limits(unsigned short *Values, short *min, short *max)
{
	unsigned int y;
	double Sum, Mean, Variance;
	if (!Values) return;

	Sum = 0;
	for (y = 0; y < this->imgSize; y++)
		Sum += Values[y];
	Mean = Sum / (double)this->imgSize;
	Sum = 0;
	for (y = 0; y < this->imgSize; y++)
		Sum += (Mean - (double)Values[y]) * (Mean - (double)Values[y]);
	Variance = Sum / (double)this->imgSize;
	Variance = Math::Sqrt(Variance);
	Variance *= 3;  // 3 Sigma
	*min = short(Mean - Variance);
	*max = short(Mean + Variance);
}

void ShowImagerForm::OnElapsed(System::Object ^sender, System::Timers::ElapsedEventArgs ^e)
{
	MyTimer ^timer = (MyTimer^)sender;
	ShowImagerForm ^sif = (ShowImagerForm ^)timer->passingRef;
	unsigned short *dataBuffer = sif->thermalDevice->getDataBuffer();

	sif->updateLabel(sif->label_info, String::Format("Info:\n\r Frame Counter: {0}, Frame Rate: {1:0.0}\n\r Sn:\t{2}, Dim: {3}x{4}", sif->thermalDevice->getFrameCount(), sif->thermalDevice->getDeviceFrequency(), sif->thermalDevice->getSerial(), sif->thermalDevice->getWidth(), sif->thermalDevice->getHeight()));

	if (sif->painted && dataBuffer)
	{
		sif->painted = false;

		sif->GetBitmap(sif->bmp, dataBuffer);
		Graphics ^g = sif->pictureBox1->CreateGraphics();
		g->DrawImage(sif->bmp, 0, 0);

		sif->painted = true;
	}
}

void ShowImagerForm::updateLabel(System::Windows::Forms::Label ^label, String ^text)
{
	if (label->InvokeRequired)
	{
		updateLabelDelegate ^uld = gcnew updateLabelDelegate(this, &ShowImagerForm::updateLabel);
		label->Invoke(uld, label, text);
	}
	else
		label->Text = text;
}